/*
 * @(#)DispatchedActionListener.java  1.1  2002-02-05
 *
 * Copyright (c) 2000 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of 
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */
package ch.randelshofer.gui.event;

import java.awt.event.*;
import java.awt.ActiveEvent;

/**
 * Invokes the actionPerformed event on the background Thread provided
 * by an EventDispatcher.
 * Note: The ActionEventListener who receives this event must be able to
 *       cope with a call to method #actionPerformed on a different thread
 *       than the user event thread.
 *
 * @author Werner Randelshofer, Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * @version 1.1 2002-02-05 Transferred from package ch.randelshofer.util to
 * ch.randelshofer.gui.event.
 * <br>1.0 2000-10-09
 */
public class DispatchedActionListener
implements ActionListener {
    private EventDispatcher dispatcher;
    private ActionListener actionListener;

    public DispatchedActionListener(ActionListener l, EventDispatcher d) {
        this.actionListener = l;
        this.dispatcher = d;
    }

    public void actionPerformed(final ActionEvent event) {
        dispatcher.dispatch(
            new ActiveEvent() {
                public void dispatch() {
                    actionListener.actionPerformed(event);
                }
            }
        );
    }
}
